import pandas as pd  
import matplotlib.pyplot as plt  
import seaborn as sns  
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Convert 'class' column to binary values  
credit_customers['class_binary'] = credit_customers['class'].apply(lambda x: 1 if x == 'good' else 0)  
  
# Create a new DataFrame with numerical values for credit_history and employment  
credit_customers_numerical = credit_customers.copy()  
credit_customers_numerical['credit_history'] = credit_customers_numerical['credit_history'].astype('category').cat.codes  
credit_customers_numerical['employment'] = credit_customers_numerical['employment'].astype('category').cat.codes  
  
# Plot scatter plots  
fig, axes = plt.subplots(2, 2, figsize=(12, 8))  
  
sns.scatterplot(data=credit_customers_numerical, x='credit_history', y='class_binary', ax=axes[0, 0])  
axes[0, 0].set_title('Loan Approval Rates vs. Credit History')  
  
sns.scatterplot(data=credit_customers_numerical, x='employment', y='class_binary', ax=axes[0, 1])  
axes[0, 1].set_title('Loan Approval Rates vs. Employment Status')  
  
sns.scatterplot(data=credit_customers_numerical, x='age', y='class_binary', ax=axes[1, 0])  
axes[1, 0].set_title('Loan Approval Rates vs. Age')  
  
sns.scatterplot(data=credit_customers_numerical, x='credit_amount', y='class_binary', ax=axes[1, 1])  
axes[1, 1].set_title('Loan Approval Rates vs. Credit Amount')  
  
plt.tight_layout()  
plt.savefig('ref_result/scatterplot.png')
plt.show() 